var back = null;

/**
 * This class encapsules all functions for the front side of the widget.
 */
function Back() {
	this.designTab = null;
	this.alarmTab = null;
	this.currentPrefs = null;
	this.imgPrefix = 'Images/button';
	this.inactiveTabFontColor = '#CCC';
	this.prefBodyHeights = {
		'Design': 45.,
		'Alarm': 70.
	}
	this._init();
}

/**
 * Init the tab bar and setup event handling.
 */
Back.prototype._init = function() {
	this.createDesignTabButtons();
	this.createAlarmTabButtons();
	$('#tabDesign_active').css('display', 'inline');
	$('#tabAlarm').css('display', 'inline');
	$('#prefsDesign').css({'display': 'block', 'opacity': '1.0'});
	this.currentPrefs = 'Design';
	
    $('#version').text(updater.getVersion());
	$('#homeLink').click(function(event) {
		widget.openURL('http://stefan.sofa-rockers.org');
	});
	$('#backgroundColor').change(function(event) {
		$('#front').css('background', 'url(Images/Front_' + event.target.value
			+ '.png) no-repeat');
		setPrefForKey(event.target.value, widget.identifier, 'background');
	});
	$('#alarmSound').change(function(event) {
		alarm.sound = event.target.value;
		timer.alarm('sound');
		setPrefForKey(event.target.value, widget.identifier, 'alarm.sound');
	});
	$('#alarmVoice').change(function(event) {
		alarm.voice = event.target.value;
		timer.alarm('voice');
		setPrefForKey(event.target.value, widget.identifier, 'alarm.voice');
	});
	$('#alarmGrowl').change(function(event) {
		alarm.growl = event.target.value;
		timer.alarm('growl');
		setPrefForKey(event.target.value, widget.identifier, 'alarm.growl');
	});
	$('#alarmKeepAlarming').change(function(event) {
		alarm.keepAlarming = event.target.checked;
		setPrefForKey(event.target.checked, widget.identifier, 
		        'alarm.keepAlarming');
	});
};

/**
 * Activate the design tab and show the design panel.
 *
 * @param event: The js event.
 */
Back.prototype.onDesignTabClicked = function(event) {
	back.switchToPrefs('Design');
};

/**
 * Activate the alarm tab and show the alarm panel.
 *
 * @param event: The js event.
 */
Back.prototype.onAlarmTabClicked = function(event) {
	back.switchToPrefs('Alarm');
};

/**
 * Change the active and inactive tab buttons, hide the old pref pane and show
 * the current. Use a fancy animation for it!
 *
 * @param prefs: The new prefs to show
 */
Back.prototype.switchToPrefs = function(prefs) {
	if (prefs == back.currentPrefs)
		return;

	$('#tab' + back.currentPrefs + '_active').css('display', 'none');
	$('#tab' + back.currentPrefs).css('display', 'inline');
	back.fadeOutPanel = '#prefs' + back.currentPrefs;

	$('#tab' + prefs).css('display', 'none');
	$('#tab' + prefs + '_active').css('display', 'inline');
	$('#prefs' + prefs).css('display', 'block');
	back.fadeInPanel = '#prefs' + prefs;

	var animator = new AppleAnimator(300, 10);
	var fadeAni = new AppleAnimation(1.0, 0.0, 
		function(animation, current, start, finish) {
			$(back.fadeOutPanel).css('opacity', '' + current);
			$(back.fadeInPanel).css('opacity', '' + (1 - current));
			if (finish)
				$(back.fadeOutPanel).css('display', 'none');
		});
	var oldHeight = $('#prefBody').css('height');
	oldHeight = parseFloat(oldHeight.substr(0, oldHeight.length - 2));
	var newHeight = back.prefBodyHeights[prefs];
	var resizeAni = new AppleAnimation(oldHeight, newHeight,
		function(animation, current, start, finish) {
			$('#prefBody').css('height', current + 'px');
		});
	animator.addAnimation(fadeAni);
	animator.addAnimation(resizeAni);
	animator.start();
	
	back.currentPrefs = prefs;
};

/**
 * Creates the active and inactive button for the design tab. For both, 
 * css:display is set to none.
 */
Back.prototype.createDesignTabButtons = function() {
	for (i = 0; i < 2; i ++) {
		active = (i == 1) ? '_active' : '';
		$('#tabDesign' + active).css('display', 'none');
		this.designTab = new AppleButton($('#tabDesign' + active).get(0),
			getLocalizedString('Design'), 20,
			this.imgPrefix + 'Left' + active + '_left.png', 
			this.imgPrefix + 'Left' + active + '_left_clicked.png', 10,
			this.imgPrefix + 'Left' + active + '_middle.png', 
			this.imgPrefix + 'Left' + active + '_middle_clicked.png',
			this.imgPrefix + 'Left' + active + '_right.png', 
			this.imgPrefix + 'Left' + active + '_right_clicked.png', 1,
			this.onDesignTabClicked);
		if (!active)
			this.designTab.textElement.style.color = this.inactiveTabFontColor;
	}
};

/**
 * Creates the active and inactive button for the alarm tab. For both, 
 * css:display is set to none.
 */
Back.prototype.createAlarmTabButtons = function(active) {
	for (i = 0; i < 2; i ++) {
		active = (i == 1) ? '_active' : '';
		$('#tabAlarm' + active).css('display', 'none');
		this.alarmTab = new AppleButton($('#tabAlarm' + active).get(0),
			getLocalizedString('Alarm'), 20,
			this.imgPrefix + 'Right' + active + '_left.png', 
			this.imgPrefix + 'Right' + active + '_left_clicked.png', 0,
			this.imgPrefix + 'Right' + active + '_middle.png', 
			this.imgPrefix + 'Right' + active + '_middle_clicked.png',
			this.imgPrefix + 'Right' + active + '_right.png', 
			this.imgPrefix + 'Right' + active + '_right_clicked.png', 10,
			this.onAlarmTabClicked);
		if (!active)
			this.alarmTab.textElement.style.color = this.inactiveTabFontColor;
	}
};
